<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class TaxDatabaseSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Seed PTKP Amounts
        DB::table('ptkp_amounts')->insert([
            ['status' => 'TK0', 'amount' => 54000000],
            ['status' => 'K0', 'amount' => 54000000 + 4500000],
            ['status' => 'K1', 'amount' => 54000000 + 4500000 + 4500000],
            ['status' => 'K2', 'amount' => 54000000 + 4500000 + 9000000],
            ['status' => 'K3', 'amount' => 54000000 + 4500000 + 13500000],
        ]);

        // Seed Tax Rates
        DB::table('tax_rates')->insert([
            // PPH OP progressive rates
            ['type' => 'PPH_OP', 'tier' => 1, 'limit' => 60000000, 'rate' => 0.05],
            ['type' => 'PPH_OP', 'tier' => 2, 'limit' => 250000000, 'rate' => 0.15],
            ['type' => 'PPH_OP', 'tier' => 3, 'limit' => 500000000, 'rate' => 0.25],
            ['type' => 'PPH_OP', 'tier' => 4, 'limit' => 5000000000, 'rate' => 0.30],
            ['type' => 'PPH_OP', 'tier' => 5, 'limit' => null, 'rate' => 0.35],
            // PPH Badan
            ['type' => 'PPH_BADAN', 'tier' => null, 'limit' => null, 'rate' => 0.22],
            // UMKM
            ['type' => 'UMKM', 'tier' => null, 'limit' => null, 'rate' => 0.005],
            // PPN
            ['type' => 'PPN', 'tier' => null, 'limit' => null, 'rate' => 0.11],
            ['type' => 'PPN_2025', 'tier' => null, 'limit' => null, 'rate' => 0.12],
            // PPH 22
            ['type' => 'PPH_22_IMPORT_API', 'tier' => null, 'limit' => null, 'rate' => 0.025],
            ['type' => 'PPH_22_IMPORT_NON_API', 'tier' => null, 'limit' => null, 'rate' => 0.075],
            ['type' => 'PPH_22_IMPORT_TERTENTU', 'tier' => null, 'limit' => null, 'rate' => 0.005],
            ['type' => 'PPH_22_PEMBELIAN_BENDAHARA', 'tier' => null, 'limit' => null, 'rate' => 0.015],
            ['type' => 'PPH_22_PEMBELIAN_BUMN', 'tier' => null, 'limit' => null, 'rate' => 0.015],
            ['type' => 'PPH_22_PENJUALAN_INDUSTRI_SEMEN', 'tier' => null, 'limit' => null, 'rate' => 0.0025],
            ['type' => 'PPH_22_PENJUALAN_INDUSTRI_KERTAS', 'tier' => null, 'limit' => null, 'rate' => 0.001],
            ['type' => 'PPH_22_PENJUALAN_INDUSTRI_BAJA', 'tier' => null, 'limit' => null, 'rate' => 0.003],
            ['type' => 'PPH_22_PENJUALAN_INDUSTRI_OTOMOTIF', 'tier' => null, 'limit' => null, 'rate' => 0.0045],
        ]);

        // Seed Tax Legal Basis
        DB::table('tax_legal_basis')->insert([
            ['type' => 'PPH_OP', 'description' => 'UU No. 7 Tahun 2021 (UU HPP), PP No. 55 Tahun 2022'],
            ['type' => 'PPH_BADAN', 'description' => 'UU No. 7 Tahun 2021 (UU HPP), Pasal 17 & 31E'],
            ['type' => 'UMKM', 'description' => 'PP No. 55 Tahun 2022'],
            ['type' => 'PPN', 'description' => 'UU No. 7 Tahun 2021 (UU HPP), PMK terkait'],
            ['type' => 'PPH_22', 'description' => 'PMK-34/PMK.010/2017 sebagaimana telah diubah terakhir dengan PMK-41/PMK.010/2022'],
        ]);
    }
}
