<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tax_legal_basis', function (Blueprint $table) {
            $table->id();
            $table->string('type'); // e.g., PPH_OP, PPH_BADAN, UMKM, PPN, PPH_22
            $table->text('description'); // Dasar hukum pajak
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tax_legal_basis');
    }
};
