<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('ptkp_amounts', function (Blueprint $table) {
            $table->id();
            $table->string('status'); // e.g., TK0, K0, K1, K2, K3
            $table->decimal('amount', 15, 2); // PTKP amount
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('ptkp_amounts');
    }
};
