<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tax_rates', function (Blueprint $table) {
            $table->id();
            $table->string('type'); // e.g., PPH_OP, PPH_BADAN, UMKM, PPN, PPH_22
            $table->integer('tier')->nullable(); // for progressive rates, 1,2,3...
            $table->decimal('limit', 15, 2)->nullable(); // upper limit for tier
            $table->decimal('rate', 5, 4); // rate as decimal, e.g., 0.05 for 5%
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tax_rates');
    }
};
